<?php
/**
 * ReadServiceInterface.php 2020-3-19
 * Gambio GmbH
 * http://www.gambio.de
 * Copyright (c) 2020 Gambio GmbH
 * Released under the GNU General Public License (Version 2)
 * [http://www.gnu.org/licenses/gpl-2.0.html]
 */

declare(strict_types=1);

namespace Gambio\Shop\Attributes\Representation\SelectionHtml;

use Gambio\Shop\Attributes\Representation\SelectionHtml\Exceptions\InvalidValueIdsSpecifiedException;
use Gambio\Shop\Attributes\Representation\SelectionHtml\Generators\ModifierHtmlGenerator;
use Gambio\Shop\Language\ValueObjects\LanguageId;
use Gambio\Shop\ProductModifiers\Modifiers\Collections\ModifierIdentifierCollectionInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\SelectedQuantity;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\SellingUnitStockInterface;

/**
 * Interface ReadServiceInterface
 * @package Gambio\Shop\Attributes\Representation\SelectionHtml
 */
interface ReadServiceInterface
{
    /**
     * @param ModifierIdentifierCollectionInterface $identifiers
     * @param LanguageId                            $languageId
     *
     * @param SelectedQuantity                      $selectedQuantity
     * @param SellingUnitStockInterface             $sellingUnitStock
     *
     * @return ModifierHtmlGenerator
     * @throws InvalidValueIdsSpecifiedException
     */
    public function selectionHtmlGenerator(
        ModifierIdentifierCollectionInterface $identifiers,
        LanguageId $languageId,
        SelectedQuantity $selectedQuantity,
        SellingUnitStockInterface $sellingUnitStock
    ): ModifierHtmlGenerator;
}